import { TxType } from "src/framework";
import { InsertTender, Licitacion, Metadata, RequestTender, Tender, TenderHistoryTO, TenderTO } from "src/licitaapp/domain";
export interface TenderRepository {
    countActiveTenders(): Promise<number>;
    getLogicalRemoveTenderIds(): Promise<TenderTO[]>;
    getAllWithouthMetadata(tx?: TxType): Promise<{
        id: number;
        description: string;
        detail: Licitacion;
    }[]>;
    logicalRemove(tenderId: number): Promise<void>;
    findByCode(code: string): Promise<Tender | undefined>;
    findByDates(initDate: Date, endDate: Date): Promise<RequestTender[]>;
    findWithoutCloseDate(): Promise<Tender[]>;
    findWithoutSubdivision(): Promise<Tender[]>;
    findByCloseDate(endDate: Date): Promise<Tender[]>;
    findByDatesUpset(initDate: Date, endDate: Date): Promise<Tender[]>;
    findById(id: number): Promise<Tender | undefined>;
    findBySubdivisionId(subdivisionId: number, withLimit?: boolean): Promise<Tender[]>;
    findInfohistoryTender(tenderId: number[]): Promise<TenderHistoryTO[]>;
    updateMetadata(tenderId: number, metadata: Metadata): Promise<void>;
    upsert(tender: InsertTender): Promise<number>;
    updateField(tender: {
        id: number;
        active: boolean;
        detail?: Licitacion;
        subdivisionId?: number | null;
    }): Promise<void>;
    updateCloseDate(tender: {
        id: number;
        closeDate: Date | null;
    }): Promise<void>;
    updateLogicalRemove(tender: {
        id: number;
        state: boolean;
    }): Promise<void>;
    updateSubdivision(tender: {
        id: number;
        subdivisionId?: number | null;
    }): Promise<void>;
    erraseByListId(tenderIds: number[]): Promise<void>;
}
