import { TxType } from "src/framework";
import { Subdivision } from "src/framework/domain/entities/subdivision.entity";
import { Company, CompanyRegisterTO, InsertCompany } from "src/licitaapp/domain";
import { CompanyUserTO } from "src/licitaapp/domain/dto/company.user.to";
export interface CompanyRepository {
    deletedCompanySubdivisions(companyId: number, tx?: TxType): Promise<void>;
    findByDNI(dni: string, tx?: TxType): Promise<Company | null>;
    findById(id: number, tx?: TxType): Promise<Company | null>;
    findCompaniesSubdivisions(companyId: number, tx?: TxType): Promise<Subdivision[]>;
    getCompanyIdsToRecalculateTender(): Promise<number[]>;
    getSubdivisionsByCompanyId(companyId: number): Promise<Subdivision[]>;
    getSubdivisionsByCompanyId(companyId: number): Promise<Subdivision[]>;
    paginationByCompanyAdmin(page: number, pageSize: number): Promise<CompanyUserTO[]>;
    save(company: InsertCompany, tx?: TxType): Promise<Company>;
    saveCompanySubdivisions(companyId: number, listSubdivisions: Subdivision[], tx?: TxType): Promise<void>;
    update(companyId: number, companyData: CompanyRegisterTO, tx?: TxType): Promise<boolean>;
    updateCheckTenders(companyId: number, checkTender: boolean, tx?: TxType): Promise<boolean>;
}
