import { z } from 'zod';
declare enum EstadoQueryEnum {
    ENVIADA_A_PROVEEDOR = "enviadaproveedor",
    ACEPTADA = "aceptada",
    CANCELADA = "cancelada",
    RECEPCION_CONFORME = "recepcionconforme",
    PENDIENTE_RECEPCION = "pendienterecepcion",
    RECEPCION_PARCIAL = "recepcionparcial",
    RECEPCION_CONFORME_INCOMPLETA = "recepcionconformeincompleta",
    TODOS = "todos"
}
declare enum TipoOrdenEnum {
    SE = "SE",
    CM = "CM"
}
declare enum TipoMonedaEnum {
    CLP = "CLP",
    CLF = "CLF",
    USD = "USD",
    UTM = "UTM",
    EUR = "EUR"
}
declare enum TipoDespachoEnum {
    DIRECCION_ENVIO = 7,
    PROGRAMA_ADJUNTADO = 9,
    OTRA_FORMA = 12,
    RETIRAMOS_BODEGA = 14,
    COURIER_AEREO = 20,
    COURIER_TERRESTRE = 21,
    A_CONVENIR = 22
}
declare enum FormaPagoEnum {
    QUINCE_DIAS = 1,
    TREINTA_DIAS = 2,
    OTRA_FORMA = 39,
    CINCUENTA_DIAS = 46,
    SESENTA_DIAS = 47
}
interface Fecha {
    FechaCreacion: Date;
    FechaEnvio: Date;
    FechaAceptacion: Date;
    FechaCancelacion: Date | null;
    FechaUltimaModificacion: Date;
}
interface Comprador {
    CodigoOrganismo: string;
    NombreOrganismo: string;
    RutUnidad: string;
    CodigoUnidad: string;
    NombreUnidad: string;
    Actividad: string;
    DireccionUnidad: string;
    ComunaUnidad: string;
    RegionUnidad: string;
    Pais: string;
    NombreContacto: string;
    CargoContacto: string;
    FonoContacto: string;
    MailContacto: string;
}
interface Proveedor {
    Codigo: string;
    Nombre: string;
    Actividad: string;
    CodigoSucursal: string;
    NombreSucursal: string;
    RutSucursal: string;
    Direccion: string;
    Comuna: string;
    Region: string;
    Pais: string;
    NombreContacto: string;
    CargoContacto: string;
    FonoContacto: string;
    MailContacto: string;
}
interface Item {
    Correlativo: number;
    CodigoCategoria: number;
    Categoria: string;
    CodigoProducto: number;
    Producto: string;
    EspecificacionComprador: string;
    EspecificacionProveedor: string;
    Cantidad: number;
    Unidad: string | null;
    Moneda: TipoMonedaEnum;
    PrecioNeto: number;
    TotalCargos: number;
    TotalDescuentos: number;
    TotalImpuestos: number;
    Total: number;
}
interface Items {
    Cantidad: number;
    Listado: Item[];
}
interface OrdenCompra {
    Codigo: string;
    Nombre: string;
    CodigoEstado: number;
    Estado: string;
    CodigoLicitacion: string;
    Descripcion: string;
    CodigoTipo: string;
    Tipo: TipoOrdenEnum;
    TipoMoneda: TipoMonedaEnum;
    CodigoEstadoProveedor: number;
    EstadoProveedor: string;
    Fechas: Fecha;
    TieneItems: boolean;
    PromedioCalificacion: number;
    CantidadEvaluacion: number;
    Descuentos: number;
    Cargos: number;
    TotalNeto: number;
    PorcentajeIva: number;
    Impuestos: number;
    Total: number;
    Financiamiento: string;
    Pais: string;
    TipoDespacho: TipoDespachoEnum;
    FormaPago: FormaPagoEnum;
    Comprador: Comprador;
    Proveedor: Proveedor;
    Items: Items;
}
declare class OrdenesDeCompraResponse {
    Cantidad: number;
    FechaCreacion: Date;
    Version: string;
    Listado: OrdenCompra[];
    static fromJson(data: OrdenesDeCompraResponse): OrdenesDeCompraResponse;
}
declare const OrdenesDeCompraQueryParamsSchema: z.ZodEffects<z.ZodObject<{
    codigo: z.ZodOptional<z.ZodString>;
    fecha: z.ZodOptional<z.ZodString>;
    estado: z.ZodOptional<z.ZodNativeEnum<typeof EstadoQueryEnum>>;
    CodigoOrganismo: z.ZodOptional<z.ZodString>;
    CodigoProveedor: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    codigo?: string | undefined;
    fecha?: string | undefined;
    estado?: EstadoQueryEnum | undefined;
    CodigoOrganismo?: string | undefined;
    CodigoProveedor?: string | undefined;
}, {
    codigo?: string | undefined;
    fecha?: string | undefined;
    estado?: EstadoQueryEnum | undefined;
    CodigoOrganismo?: string | undefined;
    CodigoProveedor?: string | undefined;
}>, {
    codigo?: string | undefined;
    fecha?: string | undefined;
    estado?: EstadoQueryEnum | undefined;
    CodigoOrganismo?: string | undefined;
    CodigoProveedor?: string | undefined;
}, {
    codigo?: string | undefined;
    fecha?: string | undefined;
    estado?: EstadoQueryEnum | undefined;
    CodigoOrganismo?: string | undefined;
    CodigoProveedor?: string | undefined;
}>;
type OrdenesDeCompraQueryParams = z.infer<typeof OrdenesDeCompraQueryParamsSchema>;
export { OrdenesDeCompraQueryParams, OrdenesDeCompraQueryParamsSchema, OrdenesDeCompraResponse, };
