"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MercadoPublicoRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MercadoPublicoRepository = void 0;
const axios_1 = require("@nestjs/axios");
const common_1 = require("@nestjs/common");
const rxjs_1 = require("rxjs");
const mp_util_1 = require("./mp.util");
const types_1 = require("./types");
const framework_1 = require("../../../framework");
let MercadoPublicoRepository = MercadoPublicoRepository_1 = class MercadoPublicoRepository {
    constructor(httpService) {
        this.httpService = httpService;
        this.LOGGER = new framework_1.PrimeLogger(MercadoPublicoRepository_1.name);
    }
    async licitaciones(args) {
        types_1.LicitacionesQueryParamsSchema.parse(args);
        const response = await (0, rxjs_1.firstValueFrom)(this.httpService
            .get('/licitaciones.json', {
            params: args,
        })
            .pipe((0, rxjs_1.map)((response) => types_1.LicitacionesResponse.fromJson((0, mp_util_1.convertDates)(response.data))))).catch((error) => {
            this.LOGGER.error(`Error retrieving licitaciones. ${error.message}. Params: ${JSON.stringify(args)}`, 'MercadoPublicoRepository');
            throw error;
        });
        return response;
    }
    async ordenesDeCompra(args) {
        types_1.OrdenesDeCompraQueryParamsSchema.parse(args);
        const response = await (0, rxjs_1.firstValueFrom)(this.httpService
            .get('/ordenesdecompra.json', {
            params: args,
        })
            .pipe((0, rxjs_1.map)((response) => types_1.OrdenesDeCompraResponse.fromJson((0, mp_util_1.convertDates)(response.data))))).catch((error) => {
            this.LOGGER.error(`Error retrieving ordenes de compra. ${error.message}. Params: ${JSON.stringify(args)}`, 'MercadoPublicoRepository');
            throw error;
        });
        return response;
    }
    async buscarProveedor(rut) {
        const response = await (0, rxjs_1.firstValueFrom)(this.httpService
            .get('/empresas/BuscarProveedor', {
            params: {
                rutempresaproveedor: rut,
            },
        })
            .pipe((0, rxjs_1.map)((response) => response.data))).catch((error) => {
            this.LOGGER.error(`Error: ${JSON.stringify(error)}`, 'MercadoPublicoRepository');
            return undefined;
        });
        return response;
    }
    async buscarComprador() {
        const response = await (0, rxjs_1.firstValueFrom)(this.httpService
            .get('/empresas/BuscarComprador')
            .pipe((0, rxjs_1.map)((response) => response.data))).catch((error) => {
            this.LOGGER.error(`Error: ${JSON.stringify(error)}`, 'MercadoPublicoRepository');
            return undefined;
        });
        return response;
    }
};
exports.MercadoPublicoRepository = MercadoPublicoRepository;
exports.MercadoPublicoRepository = MercadoPublicoRepository = MercadoPublicoRepository_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [axios_1.HttpService])
], MercadoPublicoRepository);
//# sourceMappingURL=mp.repository.js.map