"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const app_exception_logger_1 = require("../../definition/logger/app.exception.logger");
let UserServiceImpl = UserServiceImpl_1 = class UserServiceImpl {
    constructor(userRepository, firebaseService, userRoleService, roleService, emailService) {
        this.userRepository = userRepository;
        this.firebaseService = firebaseService;
        this.userRoleService = userRoleService;
        this.roleService = roleService;
        this.emailService = emailService;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(UserServiceImpl_1.name);
    }
    async updateProfiles(params) {
        this.LOGGER.log(`Updating profiles for user id: ${params.userId}`);
        const profile = await this.roleService.getRoleByKey(params.profile);
        await this.userRoleService.updateProfiles(params, profile.id);
        return 'true';
    }
    async findEmailsAdmin() {
        const userIds = await this.userRoleService.getAdminUserIds();
        return await this.userRepository.findEmailsAdmin(userIds);
    }
    async createUser(user) {
        this.LOGGER.log(`Creating user with email: ${user.email}`);
        return await this.userRepository.save(user);
    }
    async createOrUpdate(externalId, user) {
        this.LOGGER.log(`Creating or updating user with externalId: ${externalId}`);
        const existingUser = await this.userRepository.findByExternalId(externalId);
        if (existingUser) {
            this.LOGGER.log(`Updating existing user with id: ${existingUser.id}`);
            return await this.updateUser(existingUser.id, user);
        }
        const newUser = await this.createUser(user);
        this.LOGGER.log(`Created new user with id: ${newUser.id}`);
        this.LOGGER.log(`Sending welcome email to: ${newUser.email}`);
        this.emailService.sendEmail({
            to: [newUser.email],
            subject: 'LICITAAPP Bienvenido',
            text: 'Registro exitoso',
        });
        return newUser;
    }
    async getUserById(id, tx) {
        this.LOGGER.log(`Getting user by id: ${id}`);
        return await this.userRepository.findById(id, tx);
    }
    async getUserByExternalId(externalId) {
        this.LOGGER.log(`Getting user by externalId: ${externalId}`);
        return await this.userRepository.findByExternalId(externalId);
    }
    async getUserByEmail(email) {
        this.LOGGER.log(`Getting user by email: ${email}`);
        return await this.userRepository.findByEmail(email);
    }
    async updateUser(id, user) {
        this.LOGGER.log(`Updating user with id: ${id}`);
        return await this.userRepository.update(id, user);
    }
    async getAllUsers() {
        this.LOGGER.log('Getting all users');
        return await this.userRepository.findAll();
    }
    async updateAggrement(user) {
        this.LOGGER.log(`Updating user agreement for user id: ${user.id}`);
        return await this.userRepository.updateAggrement(user);
    }
    async unsubscribe(user) {
        this.LOGGER.log(`Unsubscribing user with id: ${user.id} externalid: ${user.externalId}`);
        if (user.externalId)
            await this.firebaseService.deleteUserFromFirebase(user.externalId);
        await this.userRepository.unsubscribe(user.id);
    }
    async registerUserByProfile(recordTO) {
        this.LOGGER.log(`Registering user by profile for email: ${recordTO.user.email}`);
        const user = await this.createUser(recordTO.user);
        const profile = await this.roleService.getRoleByKey(recordTO.role.shortName);
        const isValidRegister = await this.userRoleService.createUserRole(user.id, profile.id);
        if (isValidRegister) {
            this.LOGGER.log(`Sending welcome email to: ${recordTO.user.email}`);
            this.emailService.sendEmail({
                to: [recordTO.user.email],
                subject: 'LICITAAPP Bienvenido',
                text: 'Registro exitoso',
            });
        }
        return isValidRegister;
    }
    async errase(user) {
        this.LOGGER.log(`errase user with id: ${user.id} externalid: ${user.externalId}`);
        if (user.externalId)
            await this.firebaseService.deleteUserFromFirebase(user.externalId);
        this.LOGGER.log(`Deleting user with id: ${user.id} from database`);
        await this.userRepository.erraseAccount(user.id);
    }
};
exports.UserServiceImpl = UserServiceImpl;
exports.UserServiceImpl = UserServiceImpl = UserServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('UserRepository')),
    __param(1, (0, common_1.Inject)('FirebaseService')),
    __param(2, (0, common_1.Inject)('UserRoleService')),
    __param(3, (0, common_1.Inject)('RoleService')),
    __param(4, (0, common_1.Inject)('EmailService')),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Object])
], UserServiceImpl);
//# sourceMappingURL=user-service-impl.js.map