import { EmailService, FirebaseService, InsertUserRequest, ProgramUserRequestTO, RequestTenderTO, TypeMasterService, UserRequest, UserRequestService, UserRoleService, UserService } from 'src/framework';
import { UserRequestRepository } from 'src/framework/application/repository/user-request-repository/user-request-repository.interface';
import { NotificationRecordService } from 'src/framework/application/service/notification-record-service/notification-record-service.interface';
import { CompanyService } from 'src/licitaapp';
import { TenderTO } from 'src/licitaapp/domain';
export declare class UserRequestServiceImpl implements UserRequestService {
    private readonly userRequestRepository;
    private readonly typeMasterService;
    private readonly userService;
    private readonly companyService;
    private readonly emailService;
    private readonly notificationRecordService;
    private readonly userRoleService;
    private readonly firebaseService;
    private readonly LOGGER;
    constructor(userRequestRepository: UserRequestRepository, typeMasterService: TypeMasterService, userService: UserService, companyService: CompanyService, emailService: EmailService, notificationRecordService: NotificationRecordService, userRoleService: UserRoleService, firebaseService: FirebaseService);
    erraseUserRequests(tenderIds: TenderTO[]): Promise<void>;
    createProgramUserRequest(userId: number, dataUserRequest: ProgramUserRequestTO): Promise<String>;
    createUserRequest(userId: number, dataUserRequest: InsertUserRequest): Promise<UserRequest | null>;
    getPagination(page: number, pageSize: number, filter: string, shortStateUserRequest: string): Promise<RequestTenderTO[]>;
    deleteLogicalRemove(userRequestId: number): Promise<void>;
    updateUserStateOrLogicalRemove(userRequestId: number, stateRequestType: string): Promise<UserRequest | null>;
}
