"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserDeviceServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserDeviceServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const app_exception_logger_1 = require("../../definition/logger/app.exception.logger");
let UserDeviceServiceImpl = UserDeviceServiceImpl_1 = class UserDeviceServiceImpl {
    constructor(userDeviceRepository) {
        this.userDeviceRepository = userDeviceRepository;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(UserDeviceServiceImpl_1.name);
    }
    erraseUserDevice(token) {
        this.LOGGER.log(`Erasing user device with token: ${token}`);
        return this.userDeviceRepository.erraseUserDevice(token);
    }
    saveUserDevice(userId, data, tx) {
        this.LOGGER.log(`Saving user device: ${data}`);
        return this.userDeviceRepository.save(userId, data, tx);
    }
    async findTokensByUserId(userId) {
        this.LOGGER.log(`Finding tokens devices by user: ${userId}`);
        return await this.userDeviceRepository.findByUserId(userId);
    }
    async logicalRemove(userDeviceId) {
        this.LOGGER.log(`logicalRemove id ${userDeviceId}`);
        await this.userDeviceRepository.logicalRemoveById(userDeviceId);
    }
    async getAdminUserDeviceTokens() {
        this.LOGGER.log(`getAdminUserDeviceTokens`);
        return await this.userDeviceRepository.getAdminUserDeviceTokens();
    }
};
exports.UserDeviceServiceImpl = UserDeviceServiceImpl;
exports.UserDeviceServiceImpl = UserDeviceServiceImpl = UserDeviceServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('UserDeviceRepository')),
    __metadata("design:paramtypes", [Object])
], UserDeviceServiceImpl);
//# sourceMappingURL=user-device-service-impl.js.map