import { UserDeviceService } from 'src/framework/application/service/user-device-service/user-device-service.interface';
import { UserDeviceRepository } from 'src/framework/application/repository/user-device-repository/user-device-repository.interface';
import { TxType } from '../../drizzle/drizzle.types';
import { InsertUserDevice, UserDevice } from 'src/framework/domain/entities/user-device.entity';
export declare class UserDeviceServiceImpl implements UserDeviceService {
    private readonly userDeviceRepository;
    private readonly LOGGER;
    constructor(userDeviceRepository: UserDeviceRepository);
    erraseUserDevice(token: string): Promise<void>;
    saveUserDevice(userId: number, data: InsertUserDevice, tx?: TxType): Promise<UserDevice>;
    findTokensByUserId(userId: number): Promise<string[]>;
    logicalRemove(userDeviceId: number): Promise<void>;
    getAdminUserDeviceTokens(): Promise<string[]>;
}
