"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserCampaignsServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCampaignsServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const definition_1 = require("../../definition");
let UserCampaignsServiceImpl = UserCampaignsServiceImpl_1 = class UserCampaignsServiceImpl {
    constructor(userCampaignsRepository) {
        this.userCampaignsRepository = userCampaignsRepository;
        this.LOGGER = new definition_1.PrimeLogger(UserCampaignsServiceImpl_1.name);
    }
    getActiveCampaigns() {
        this.LOGGER.log('Getting active user campaigns...');
        return this.userCampaignsRepository.getActiveCampaigns();
    }
    create(data) {
        this.LOGGER.log('Creating user campaign...');
        return this.userCampaignsRepository.create(data);
    }
    update(data) {
        this.LOGGER.log('Updating user campaign...');
        return this.userCampaignsRepository.update(data);
    }
    getPagination(page, pageSize, filter) {
        this.LOGGER.log(`Getting paginated user campaigns - page: ${page}, pageSize: ${pageSize}, filter: ${filter}`);
        return this.userCampaignsRepository.getPagination(page, pageSize, filter);
    }
    logicalRemove(campaignId) {
        this.LOGGER.log(`Logical removing user campaign with ID: ${campaignId}`);
        return this.userCampaignsRepository.logicalRemove(campaignId);
    }
};
exports.UserCampaignsServiceImpl = UserCampaignsServiceImpl;
exports.UserCampaignsServiceImpl = UserCampaignsServiceImpl = UserCampaignsServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('UserCampaignsRepository')),
    __metadata("design:paramtypes", [Object])
], UserCampaignsServiceImpl);
//# sourceMappingURL=user-campaigns-service-impl.js.map