import { UserRequestRepository } from 'src/framework/application/repository/user-request-repository/user-request-repository.interface';
import { InsertUserRequest, RequestTenderTO, UpdateUserRequest, UserRequest } from 'src/framework/domain';
import { DBConfigService } from '../../drizzle';
import { TxType } from '../../drizzle/drizzle.types';
import { TenderTO } from 'src/licitaapp/domain';
export declare class UserRequestRepositoryImpl implements UserRequestRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    erraseUserRequests(tenderIds: TenderTO[]): Promise<void>;
    save(dataInsert: InsertUserRequest, userId: number, tx?: TxType): Promise<UserRequest>;
    existUserRequest(userId: number, tenderId: number, companyId: number): Promise<number>;
    findById(id: number, tx?: TxType): Promise<UserRequest | null>;
    update(userRequestId: number, objectUpdateData: UpdateUserRequest, tx?: TxType): Promise<UserRequest | null>;
    getPagination(page: number, pageSize: number, shortStateUserRequest: string, filter: string): Promise<RequestTenderTO[]>;
    private evalFullName;
    logicalRemove(userRequestId: number, tx?: TxType): Promise<void>;
    updateState(userRequestId: number, stateRequestTypeId: number, active: boolean, tx?: TxType): Promise<UserRequest | null>;
}
