import { UserRepository } from 'src/framework/application';
import { User, InsertUser, UpdateUser, Role } from 'src/framework/domain';
import { DBConfigService } from 'src/framework/infrastructure/drizzle';
import { TxType } from 'src/framework/infrastructure/drizzle/drizzle.types';
export declare class UserRepositoryImpl implements UserRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    findAll(): Promise<User[]>;
    findEmailsAdmin(userIds: number[]): Promise<string[]>;
    findByEmail(email: string): Promise<User | null | undefined>;
    findById(id: number, tx?: TxType): Promise<User | null | undefined>;
    findByExternalId(externalId: string): Promise<User | null | undefined>;
    save(user: InsertUser): Promise<User>;
    update(id: number, user: UpdateUser): Promise<User>;
    findUserProfiles(userId: number): Promise<Role[]>;
    updateAggrement(user: User): Promise<string>;
    unsubscribe(userId: number): Promise<User>;
    erraseAccount(userId: number): Promise<boolean>;
}
