import { UserCampaignsRepository } from 'src/framework/application/repository/user-campaigns-repository/user-campaigns-repository.interface';
import { DBConfigService } from '../../drizzle';
import { InsertUserCampaign, UpdateUserCampaign, UserCampaign } from 'src/framework/domain';
export declare class UserCampaignsRepositoryImpl implements UserCampaignsRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    getActiveCampaigns(): Promise<UserCampaign[]>;
    create(data: InsertUserCampaign): Promise<UserCampaign | null | undefined>;
    findById(id: number): Promise<UserCampaign | null | undefined>;
    update(data: UpdateUserCampaign): Promise<string>;
    getPagination(page: number, pageSize: number, defaultMessageFilter?: string): Promise<UserCampaign[]>;
    logicalRemove(campaignId: number): Promise<void>;
}
