"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var NotificationRecordRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationRecordRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const domain_1 = require("../../../domain");
const drizzle_1 = require("../../drizzle");
const definition_1 = require("../../definition");
const schema = require("../../drizzle/migrations/schema");
const util_1 = require("../../../../licitaapp/domain/util");
const drizzle_orm_1 = require("drizzle-orm");
let NotificationRecordRepositoryImpl = NotificationRecordRepositoryImpl_1 = class NotificationRecordRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new definition_1.PrimeLogger(NotificationRecordRepositoryImpl_1.name);
    }
    async erraseNotificationRecordsByTender(tenderIds, tx) {
        this.LOGGER.log(`Erasing notification records for tenders with IDs: ${tenderIds.join(', ')}`);
        await (tx || this.db.conn)
            .delete(schema.notificationRecordTable)
            .where((0, drizzle_orm_1.inArray)(schema.notificationRecordTable.tenderId, tenderIds))
            .execute();
    }
    async markNotificationEmailAsSent(notificationRecordId, tx) {
        this.LOGGER.log(`markNotificationEmailAsSent notificationRecordId: ${notificationRecordId}`);
        await (tx || this.db.conn)
            .update(schema.notificationRecordTable)
            .set({ sendEmail: true, updatedAt: util_1.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.inArray)(schema.notificationRecordTable.id, notificationRecordId));
    }
    async saveAll(notificationRecords, tx) {
        this.LOGGER.log(`saveAll notificationRecords size: ${notificationRecords.length}`);
        const validatedNotificationRecord = notificationRecords.map((notificationRecord) => schema.notificationRecordTableInsertSchema.parse(notificationRecord));
        await (tx || this.db.conn)
            .insert(schema.notificationRecordTable)
            .values(validatedNotificationRecord)
            .execute();
    }
    async updateNotification(notificationRecordId, notificationRecord, tx) {
        this.LOGGER.log(`updateNotification notificationRecord: ${notificationRecordId}`);
        await (this.db.conn)
            .update(schema.notificationRecordTable)
            .set({
            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            active: notificationRecord.active,
        })
            .where((0, drizzle_orm_1.eq)(schema.notificationRecordTable.id, notificationRecordId));
    }
    async getActiveNotificationRecords(userId, isAdmin = false) {
        this.LOGGER.log(`getActiveNotificationRecords userId: ${userId}`);
        if (isAdmin) {
            return await this.db.conn
                .select({
                id: schema.notificationRecordTable.id,
                userId: schema.notificationRecordTable.userId,
                title: schema.notificationRecordTable.title,
                defaultMessage: schema.notificationRecordTable.defaultMessage,
                active: schema.notificationRecordTable.active,
                createdAt: schema.notificationRecordTable.createdAt,
                updatedAt: schema.notificationRecordTable.updatedAt,
                monthFilterTender: schema.notificationRecordTable.monthFilterTender,
                tenderId: schema.notificationRecordTable.tenderId,
            })
                .from(schema.notificationRecordTable)
                .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.notificationRecordTable.active, true), (0, drizzle_orm_1.eq)(schema.notificationRecordTable.isAdmin, isAdmin))).then((rows) => {
                return rows.map((row) => new domain_1.NotificationRecord(row.id, row.userId, row.title, row.defaultMessage, row.active, row.createdAt, row.updatedAt, row.tenderId ? row.tenderId : undefined, undefined, row.monthFilterTender));
            });
        }
        return await this.db.conn
            .select({
            id: schema.notificationRecordTable.id,
            userId: schema.notificationRecordTable.userId,
            title: schema.notificationRecordTable.title,
            defaultMessage: schema.notificationRecordTable.defaultMessage,
            active: schema.notificationRecordTable.active,
            createdAt: schema.notificationRecordTable.createdAt,
            updatedAt: schema.notificationRecordTable.updatedAt,
            monthFilterTender: schema.notificationRecordTable.monthFilterTender,
            tenderId: schema.notificationRecordTable.tenderId,
        })
            .from(schema.notificationRecordTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.notificationRecordTable.userId, userId), (0, drizzle_orm_1.eq)(schema.notificationRecordTable.active, true), (0, drizzle_orm_1.eq)(schema.notificationRecordTable.isAdmin, isAdmin))).then((rows) => {
            return rows.map((row) => new domain_1.NotificationRecord(row.id, row.userId, row.title, row.defaultMessage, row.active, row.createdAt, row.updatedAt, row.tenderId ? row.tenderId : undefined, undefined, row.monthFilterTender));
        });
    }
    async getNotificationRecordsPaginated(userId, page, pageSize) {
        this.LOGGER.log(`getNotificationRecordsPaginated userId: ${userId} page: ${page} pageSize: ${pageSize}`);
        return await this.db.conn
            .select({
            id: schema.notificationRecordTable.id,
            userId: schema.notificationRecordTable.userId,
            title: schema.notificationRecordTable.title,
            defaultMessage: schema.notificationRecordTable.defaultMessage,
            active: schema.notificationRecordTable.active,
            createdAt: schema.notificationRecordTable.createdAt,
            updatedAt: schema.notificationRecordTable.updatedAt,
        })
            .from(schema.notificationRecordTable)
            .where((0, drizzle_orm_1.eq)(schema.notificationRecordTable.userId, userId))
            .orderBy((0, drizzle_orm_1.desc)(schema.notificationRecordTable.createdAt))
            .limit(Number(pageSize))
            .offset(pageSize * (page - 1))
            .then((rows) => {
            return rows.map((row) => new domain_1.NotificationRecord(row.id, row.userId, row.title, row.defaultMessage, row.active, row.createdAt, row.updatedAt));
        });
    }
    async logicalRemoveBYListId(ids, tx) {
        this.LOGGER.log(`logicalRemoveBYListId ids: ${ids}`);
        await (tx || this.db.conn)
            .update(schema.notificationRecordTable)
            .set({ active: false, deletedAt: util_1.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.inArray)(schema.notificationRecordTable.id, ids));
    }
    async getAdminNotification() {
        this.LOGGER.log(`getAdminNotification`);
        return await this.db.conn
            .select({
            id: schema.notificationRecordTable.id,
            userId: schema.notificationRecordTable.userId,
            title: schema.notificationRecordTable.title,
            defaultMessage: schema.notificationRecordTable.defaultMessage,
        })
            .from(schema.notificationRecordTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.notificationRecordTable.sendEmail, false), (0, drizzle_orm_1.eq)(schema.notificationRecordTable.isAdmin, true)))
            .then((rows) => {
            return rows.map((row) => {
                return new domain_1.NotificationRecord(row.id, row.userId, row.title, row.defaultMessage, undefined, undefined, undefined, undefined, undefined, undefined, undefined);
            });
        });
    }
    async getUserNotificationRecordsActive() {
        this.LOGGER.log(`getUserNotificationRecordsActive`);
        return await this.db.conn
            .select({
            id: schema.notificationRecordTable.id,
            userId: schema.notificationRecordTable.userId,
            title: schema.notificationRecordTable.title,
            defaultMessage: schema.notificationRecordTable.defaultMessage,
            amountWords: schema.notificationRecordTable.amountWords,
            amountGeo: schema.notificationRecordTable.amountGeo,
            userEmail: schema.userTable.email,
        })
            .from(schema.notificationRecordTable)
            .leftJoin(schema.userTable, (0, drizzle_orm_1.eq)(schema.notificationRecordTable.userId, schema.userTable.id))
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.notificationRecordTable.sendEmail, false)))
            .then((rows) => {
            return rows.map((row) => {
                const element = new domain_1.NotificationRecord(row.id, row.userId, row.title, row.defaultMessage, undefined, undefined, undefined, undefined, undefined, undefined, undefined, row.amountWords, row.amountGeo);
                element.userEmail = row.userEmail;
                return element;
            });
        });
    }
};
exports.NotificationRecordRepositoryImpl = NotificationRecordRepositoryImpl;
exports.NotificationRecordRepositoryImpl = NotificationRecordRepositoryImpl = NotificationRecordRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_1.DBConfigService])
], NotificationRecordRepositoryImpl);
//# sourceMappingURL=notification-record-repository-impl.js.map