"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var GeoRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeoRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const domain_1 = require("../../../domain");
const drizzle_1 = require("../../drizzle");
const schema_1 = require("../../drizzle/migrations/schema");
const drizzle_orm_1 = require("drizzle-orm");
const definition_1 = require("../../definition");
const subdivision_entity_1 = require("../../../domain/entities/subdivision.entity");
let GeoRepositoryImpl = GeoRepositoryImpl_1 = class GeoRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new definition_1.PrimeLogger(GeoRepositoryImpl_1.name);
    }
    async findCountries() {
        return await this.db.conn
            .select({
            id: schema_1.countryTable.id,
            name: schema_1.countryTable.name,
            fullName: schema_1.countryTable.fullName,
            code: schema_1.countryTable.code,
            iso3: schema_1.countryTable.iso3,
            number: schema_1.countryTable.number,
        })
            .from(schema_1.countryTable)
            .orderBy((0, drizzle_orm_1.asc)(schema_1.countryTable.name))
            .then((rows) => {
            return rows.map((row) => {
                return new domain_1.Country(row.id, row.code, row.iso3, row.number, row.name, row.fullName);
            });
        });
    }
    async findCountryById(id) {
        return await this.db.conn
            .select({
            id: schema_1.countryTable.id,
            name: schema_1.countryTable.name,
            fullName: schema_1.countryTable.fullName,
            code: schema_1.countryTable.code,
            iso3: schema_1.countryTable.iso3,
            number: schema_1.countryTable.number,
        })
            .from(schema_1.countryTable)
            .where((0, drizzle_orm_1.eq)(schema_1.countryTable.id, id))
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            const row = rows[0];
            return new domain_1.Country(row.id, row.code, row.iso3, row.number, row.name, row.fullName);
        });
    }
    async findSubdivisionsByCountryCode(countryCode) {
        return this.db.conn
            .select({
            id: schema_1.subdivisionTable.id,
            name: schema_1.subdivisionTable.name,
            code: schema_1.subdivisionTable.code,
        })
            .from(schema_1.subdivisionTable)
            .innerJoin(schema_1.countryTable, (0, drizzle_orm_1.eq)(schema_1.subdivisionTable.countryId, schema_1.countryTable.id))
            .where((0, drizzle_orm_1.eq)(schema_1.countryTable.code, countryCode))
            .orderBy((0, drizzle_orm_1.asc)(schema_1.subdivisionTable.name))
            .then((rows) => {
            var output = [new subdivision_entity_1.Subdivision(7777, 'all', 'Seleccionar todos')];
            for (var i = 0; i < rows.length; i++) {
                output.push(new subdivision_entity_1.Subdivision(rows[i].id, rows[i].code, rows[i].name));
            }
            return output;
        });
    }
    async findAdmdivisionsBySubdivisionCode(subdivisionCode) {
        return this.db.conn
            .select({
            id: schema_1.administrativeDivisionTable.id,
            name: schema_1.administrativeDivisionTable.name,
            code: schema_1.administrativeDivisionTable.code,
        })
            .from(schema_1.administrativeDivisionTable)
            .where((0, drizzle_orm_1.eq)(schema_1.administrativeDivisionTable.subdivisionId, subdivisionCode))
            .orderBy((0, drizzle_orm_1.asc)(schema_1.administrativeDivisionTable.name))
            .then((rows) => {
            return rows.map((row) => {
                return new domain_1.AdministrativeDivision(row.id, row.code, row.name);
            });
        });
    }
    async findAdmdivisionsByCountry(prefixCode) {
        this.LOGGER.log(`findAdmdivisionsByCountry - prefixCode: ${prefixCode}`);
        return this.db.conn
            .select({
            id: schema_1.administrativeDivisionTable.id,
            name: schema_1.administrativeDivisionTable.name,
            code: schema_1.administrativeDivisionTable.code,
            subdivisionId: schema_1.administrativeDivisionTable.subdivisionId,
        })
            .from(schema_1.administrativeDivisionTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.like)(schema_1.administrativeDivisionTable.code, `${prefixCode}%`), (0, drizzle_orm_1.eq)(schema_1.administrativeDivisionTable.active, true)))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => {
                return new domain_1.AdministrativeDivision(row.id, row.code, row.name, row.subdivisionId);
            });
        });
    }
};
exports.GeoRepositoryImpl = GeoRepositoryImpl;
exports.GeoRepositoryImpl = GeoRepositoryImpl = GeoRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_1.DBConfigService])
], GeoRepositoryImpl);
//# sourceMappingURL=geo-repository-impl.js.map