"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.userCompanyTenderTableSelectSchema = exports.userCompanyTenderTableUpdateSchema = exports.userCompanyTenderTableInsertSchema = exports.keywordTableSelectSchema = exports.keywordTableUpdateSchema = exports.keywordTableInsertSchema = exports.userCompanyTableSelectSchema = exports.userCompanyTableUpdateSchema = exports.userCompanyTableInsertSchema = exports.companyTableSelectSchema = exports.companyTableUpdateSchema = exports.companyTableInsertSchema = exports.userRoleTableSelectSchema = exports.userRoleTableUpdateSchema = exports.userRoleTableInsertSchema = exports.typeMasterTableSelectSchema = exports.typeMasterTableUpdateSchema = exports.typeMasterTableInsertSchema = exports.roleTableSelectSchema = exports.roleTableUpdateSchema = exports.roleTableInsertSchema = exports.userTableSelectSchema = exports.userTableUpdateSchema = exports.userTableInsertSchema = exports.notificationRecordTableSelectSchema = exports.notificationRecordTableUpdateSchema = exports.notificationRecordTableInsertSchema = exports.applicationLogTableSelectSchema = exports.applicationLogTableUpdateSchema = exports.applicationLogTableInsertSchema = exports.userCampaignTable = exports.applicationLogTable = exports.notificationRecordTable = exports.userRequestTable = exports.administrativeDivisionTable = exports.userDeviceTable = exports.subdivisionTable = exports.countryTable = exports.continentTable = exports.userHistoryTenderTable = exports.userCompanyTenderTable = exports.tenderTable = exports.keywordTable = exports.typeMasterTable = exports.userCompanyTable = exports.companySubdivisionTable = exports.companyTable = exports.userRoleTable = exports.roleTable = exports.userTable = void 0;
exports.userCampaignTableSelectSchema = exports.userCampaignTableUpdateSchema = exports.userCampaignTableInsertSchema = exports.userRequestTableSelectSchema = exports.userRequestTableUpdateSchema = exports.userRequestTableInsertSchema = exports.userDeviceTableSelectSchema = exports.userDeviceTableUpdateSchema = exports.userDeviceTableInsertSchema = exports.tenderTableSelectSchema = exports.tenderTableUpdateSchema = exports.tenderTableInsertSchema = exports.userHistoryTenderTableSelectSchema = exports.userHistoryTenderTableUpdateSchema = exports.userHistoryTenderTableInsertSchema = void 0;
const mysql_core_1 = require("drizzle-orm/mysql-core");
const drizzle_zod_1 = require("drizzle-zod");
const zod_1 = require("zod");
const allow_roles_decorator_1 = require("../../decorators/allow-profiles/allow-roles.decorator");
const domain_1 = require("../../../../licitaapp/domain");
const enum_definition_1 = require("../../../../licitaapp/domain/enum/enum.definition");
const enum_definition_2 = require("../../../domain/enum/enum.definition");
const TIMESTAMP_CONFIG = {
    mode: 'date',
};
const AUDIT_COLUMNS = {
    createdAt: (0, mysql_core_1.timestamp)('created_at', TIMESTAMP_CONFIG).notNull().defaultNow(),
    updatedAt: (0, mysql_core_1.timestamp)('updated_at', TIMESTAMP_CONFIG).onUpdateNow(),
    deletedAt: (0, mysql_core_1.timestamp)('deleted_at', TIMESTAMP_CONFIG),
    active: (0, mysql_core_1.boolean)('active').notNull().default(true),
};
exports.userTable = (0, mysql_core_1.mysqlTable)('user', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    agreementAt: (0, mysql_core_1.timestamp)('agreement_at', TIMESTAMP_CONFIG),
    name: (0, mysql_core_1.varchar)('name', { length: 60 }).notNull(),
    email: (0, mysql_core_1.varchar)('email', { length: 256 }).notNull(),
    lastName: (0, mysql_core_1.varchar)('last_name', { length: 60 }),
    lastname2: (0, mysql_core_1.varchar)('last_name_2', { length: 60 }),
    cellPhone: (0, mysql_core_1.varchar)('cell_phone', { length: 20 }),
    externalId: (0, mysql_core_1.varchar)('external_id', { length: 256 }),
});
const roleShortNames = Object.values(allow_roles_decorator_1.RoleShortNameEnum);
exports.roleTable = (0, mysql_core_1.mysqlTable)('profile', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    name: (0, mysql_core_1.varchar)('name', { length: 60 }).notNull(),
    shortName: (0, mysql_core_1.mysqlEnum)('short_name', roleShortNames)
        .$type()
        .notNull(),
});
exports.userRoleTable = (0, mysql_core_1.mysqlTable)('user_profile', {
    userId: (0, mysql_core_1.bigint)('user_id', { mode: 'number' })
        .primaryKey()
        .references(() => exports.userTable.id),
    roleId: (0, mysql_core_1.bigint)('profile_id', { mode: 'number' })
        .primaryKey()
        .references(() => exports.roleTable.id),
});
exports.companyTable = (0, mysql_core_1.mysqlTable)('company', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    dni: (0, mysql_core_1.varchar)('dni', { length: 60 }).notNull(),
    socialReason: (0, mysql_core_1.varchar)('social_reason', { length: 256 }).notNull(),
    checkTender: (0, mysql_core_1.boolean)('check_tender').notNull().default(false),
});
exports.companySubdivisionTable = (0, mysql_core_1.mysqlTable)('company_subdivision', {
    companyId: (0, mysql_core_1.bigint)('company_id', { mode: 'number' })
        .primaryKey()
        .references(() => exports.companyTable.id),
    subdivisionId: (0, mysql_core_1.bigint)('subdivision_id', { mode: 'number' })
        .primaryKey()
        .references(() => exports.subdivisionTable.id),
});
exports.userCompanyTable = (0, mysql_core_1.mysqlTable)('user_company', {
    userId: (0, mysql_core_1.bigint)('user_id', { mode: 'number' })
        .primaryKey()
        .references(() => exports.userTable.id),
    companyId: (0, mysql_core_1.bigint)('company_id', { mode: 'number' })
        .primaryKey()
        .references(() => exports.companyTable.id),
});
exports.typeMasterTable = (0, mysql_core_1.mysqlTable)('type_master', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    discriminator: (0, mysql_core_1.mysqlEnum)('discriminator', [
        enum_definition_2.TypeMasterDiscriminatorEnum.TUTORIAL_TYPE,
        enum_definition_2.TypeMasterDiscriminatorEnum.STATE_REQUEST_TYPE,
    ])
        .$type()
        .notNull(),
    shortName: (0, mysql_core_1.varchar)(('short_name'), { length: 256 }).notNull(),
    name: (0, mysql_core_1.varchar)('name', { length: 256 }).notNull(),
    order: (0, mysql_core_1.smallint)('order').default(1).notNull()
});
exports.keywordTable = (0, mysql_core_1.mysqlTable)('keyword', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    value: (0, mysql_core_1.varchar)('value', { length: 256 }).notNull(),
    userId: (0, mysql_core_1.bigint)('user_id', { mode: 'number' }).notNull().references(() => exports.userTable.id),
    origin: (0, mysql_core_1.mysqlEnum)('origin', [
        domain_1.KeywordOrigin.MERCADO_PUBLICO,
        domain_1.KeywordOrigin.USER,
    ])
        .$type()
        .default(domain_1.KeywordOrigin.USER)
        .notNull(),
    companyId: (0, mysql_core_1.bigint)('company_id', { mode: 'number' })
        .notNull()
        .references(() => exports.companyTable.id),
    metadata: (0, mysql_core_1.json)('metadata').$type(),
});
exports.tenderTable = (0, mysql_core_1.mysqlTable)('tender', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    closeDate: (0, mysql_core_1.timestamp)('close_date', TIMESTAMP_CONFIG),
    code: (0, mysql_core_1.varchar)('code', { length: 60 }).unique().notNull(),
    name: (0, mysql_core_1.varchar)('name', { length: 256 }).notNull(),
    description: (0, mysql_core_1.text)('description').notNull(),
    subdivisionId: (0, mysql_core_1.bigint)('subdivision_id', { mode: 'number' }).references(() => exports.subdivisionTable.id),
    details: (0, mysql_core_1.json)('details').$type().notNull(),
    metadata: (0, mysql_core_1.json)('metadata').$type(),
});
exports.userCompanyTenderTable = (0, mysql_core_1.mysqlTable)('user_company_tender', {
    userId: (0, mysql_core_1.bigint)('user_id', { mode: 'number' }).primaryKey(),
    companyId: (0, mysql_core_1.bigint)('company_id', { mode: 'number' }).primaryKey(),
    tenderId: (0, mysql_core_1.bigint)('tender_id', { mode: 'number' }).primaryKey(),
    ...AUDIT_COLUMNS,
    isFavorite: (0, mysql_core_1.boolean)('is_favorite').notNull().default(false),
    source: (0, mysql_core_1.varchar)('source', { length: 256 }).notNull(),
    isBuyAgile: (0, mysql_core_1.boolean)('is_buy_agile').notNull().default(false),
    matchResult: (0, mysql_core_1.text)('match_result'),
});
exports.userHistoryTenderTable = (0, mysql_core_1.mysqlTable)('user_history_tender', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    userId: (0, mysql_core_1.bigint)('user_id', { mode: 'number' }).notNull().references(() => exports.userTable.id),
    tenderId: (0, mysql_core_1.bigint)('tender_id', { mode: 'number' }).references(() => exports.tenderTable.id),
    codeTender: (0, mysql_core_1.varchar)('code_tender', { length: 60 }),
    metadata: (0, mysql_core_1.json)('metadata').$type(),
});
exports.continentTable = (0, mysql_core_1.mysqlTable)('continent', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    code: (0, mysql_core_1.varchar)('code', { length: 2 }).notNull(),
    name: (0, mysql_core_1.varchar)('name', { length: 16 }).notNull(),
});
exports.countryTable = (0, mysql_core_1.mysqlTable)('country', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    code: (0, mysql_core_1.varchar)('code', { length: 2 }).notNull(),
    iso3: (0, mysql_core_1.varchar)('iso3', { length: 3 }).notNull(),
    number: (0, mysql_core_1.varchar)('number', { length: 3 }).notNull(),
    continentId: (0, mysql_core_1.bigint)('continent_id', { mode: 'number' }).references(() => exports.continentTable.id),
    name: (0, mysql_core_1.varchar)('name', { length: 64 }).notNull(),
    fullName: (0, mysql_core_1.varchar)('full_name', { length: 128 }).notNull(),
});
exports.subdivisionTable = (0, mysql_core_1.mysqlTable)('subdivision', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    code: (0, mysql_core_1.varchar)('code', { length: 12 }).notNull(),
    countryId: (0, mysql_core_1.bigint)('country_id', { mode: 'number' }).references(() => exports.countryTable.id),
    name: (0, mysql_core_1.varchar)('name', { length: 256 }).notNull(),
});
exports.userDeviceTable = (0, mysql_core_1.mysqlTable)('user_device', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    userId: (0, mysql_core_1.bigint)('user_id', { mode: 'number' }).notNull().references(() => exports.userTable.id),
    token: (0, mysql_core_1.text)('token').notNull(),
    information: (0, mysql_core_1.varchar)('information', { length: 256 }).notNull(),
});
exports.administrativeDivisionTable = (0, mysql_core_1.mysqlTable)('administrative_division', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    code: (0, mysql_core_1.varchar)('code', { length: 12 }).notNull(),
    subdivisionId: (0, mysql_core_1.bigint)('subdivision_id', { mode: 'number' }).references(() => exports.subdivisionTable.id).notNull(),
    name: (0, mysql_core_1.varchar)('name', { length: 256 }).notNull(),
});
exports.userRequestTable = (0, mysql_core_1.mysqlTable)('user_request', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    userId: (0, mysql_core_1.bigint)('user_id', { mode: 'number' }).notNull().references(() => exports.userTable.id),
    companyId: (0, mysql_core_1.bigint)('company_id', { mode: 'number' }).notNull().references(() => exports.companyTable.id),
    stateRequestTypeId: (0, mysql_core_1.bigint)('state_request_type_id', { mode: 'number' })
        .notNull().references(() => exports.typeMasterTable.id),
    title: (0, mysql_core_1.varchar)('title', { length: 60 }).notNull(),
    description: (0, mysql_core_1.text)('description').notNull(),
    tenderId: (0, mysql_core_1.bigint)('tender_id', { mode: 'number' }).references(() => exports.tenderTable.id),
});
exports.notificationRecordTable = (0, mysql_core_1.mysqlTable)('notification_record', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    monthFilterTender: (0, mysql_core_1.timestamp)('month_filter_tender', TIMESTAMP_CONFIG),
    userId: (0, mysql_core_1.bigint)('user_id', { mode: 'number' }).notNull().references(() => exports.userTable.id),
    tenderId: (0, mysql_core_1.bigint)('tender_id', { mode: 'number' }).references(() => exports.tenderTable.id),
    subdivisionId: (0, mysql_core_1.bigint)('subdivision_id', { mode: 'number' }).references(() => exports.subdivisionTable.id),
    title: (0, mysql_core_1.varchar)('title', { length: 60 }).notNull(),
    defaultMessage: (0, mysql_core_1.varchar)('default_message', { length: 256 }).notNull(),
    sendEmail: (0, mysql_core_1.boolean)('send_email').notNull().default(false),
    amountWords: (0, mysql_core_1.bigint)('amount_words', { mode: 'number' }).notNull().default(0),
    amountGeo: (0, mysql_core_1.bigint)('amount_geo', { mode: 'number' }).notNull().default(0),
    isAdmin: (0, mysql_core_1.boolean)('is_admin').notNull().default(false),
});
exports.applicationLogTable = (0, mysql_core_1.mysqlTable)('application_log', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    userName: (0, mysql_core_1.varchar)('user_name', { length: 120 }).notNull(),
    statusTypeId: (0, mysql_core_1.bigint)('status_type_id', { mode: 'number' })
        .notNull().references(() => exports.typeMasterTable.id),
    detail: (0, mysql_core_1.text)('detail').notNull(),
    type: (0, mysql_core_1.mysqlEnum)('type', [
        enum_definition_1.ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG,
        enum_definition_1.ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG,
        enum_definition_1.ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG,
        enum_definition_1.ApplicationTypeEnum.METADATA_TASK_LOG,
        enum_definition_1.ApplicationTypeEnum.KEYWORDS_LOG,
        enum_definition_1.ApplicationTypeEnum.TENDER_WITHOUT_META_LOG,
        enum_definition_1.ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG,
        enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG,
        enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG,
        enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG,
        enum_definition_1.ApplicationTypeEnum.SUMMARY_ADMIN_LOG,
        enum_definition_1.ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG,
        enum_definition_1.ApplicationTypeEnum.SEARCH_TENDERS_MERCADO_PUBLICO_LOG,
        enum_definition_1.ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG,
    ])
        .$type()
        .notNull()
});
exports.userCampaignTable = (0, mysql_core_1.mysqlTable)('user_campaign', {
    id: (0, mysql_core_1.bigint)('id', { mode: 'number' }).autoincrement().primaryKey(),
    ...AUDIT_COLUMNS,
    description: (0, mysql_core_1.varchar)('description', { length: 60 }).notNull(),
    title: (0, mysql_core_1.varchar)('title', { length: 60 }).notNull(),
    defaultMessage: (0, mysql_core_1.varchar)('default_message', { length: 256 }).notNull(),
    dayOfWeek: (0, mysql_core_1.varchar)('day_of_week', { length: 60 }).notNull(),
    defHour: (0, mysql_core_1.smallint)('def_hour'),
    defMinute: (0, mysql_core_1.smallint)('def_minute'),
});
exports.applicationLogTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.applicationLogTable);
exports.applicationLogTableUpdateSchema = exports.applicationLogTableInsertSchema.partial();
exports.applicationLogTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.applicationLogTable).pick({
    id: true,
    userName: true,
    statusTypeId: true,
    detail: true,
    type: true,
});
exports.notificationRecordTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.notificationRecordTable);
exports.notificationRecordTableUpdateSchema = exports.notificationRecordTableInsertSchema.partial();
exports.notificationRecordTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.notificationRecordTable).pick({
    id: true,
    userId: true,
    title: true,
    defaultMessage: true,
    tenderId: true,
    subdivisionId: true,
    sendEmail: true,
    amountWords: true,
    amountGeo: true,
    isAdmin: true,
});
exports.userTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.userTable);
exports.userTableUpdateSchema = exports.userTableInsertSchema.partial();
exports.userTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.userTable).pick({
    id: true,
    name: true,
    email: true,
    lastName: true,
    lastname2: true,
    cellPhone: true,
});
exports.roleTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.roleTable);
exports.roleTableUpdateSchema = exports.roleTableInsertSchema.partial();
exports.roleTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.roleTable).pick({
    id: true,
    name: true,
    shortName: true,
});
exports.typeMasterTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.typeMasterTable);
exports.typeMasterTableUpdateSchema = exports.typeMasterTableInsertSchema.partial();
exports.typeMasterTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.typeMasterTable).pick({
    id: true,
    name: true,
    shortName: true,
    discriminator: true,
    order: true,
});
exports.userRoleTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.userRoleTable);
exports.userRoleTableUpdateSchema = exports.userRoleTableInsertSchema.partial();
exports.userRoleTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.userRoleTable).pick({
    userId: true,
    roleId: true,
});
exports.companyTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.companyTable);
exports.companyTableUpdateSchema = exports.companyTableInsertSchema.partial();
exports.companyTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.companyTable).pick({
    id: true,
    dni: true,
    socialReason: true,
    checkTender: true,
});
exports.userCompanyTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.userCompanyTable);
exports.userCompanyTableUpdateSchema = exports.userCompanyTableInsertSchema.partial();
exports.userCompanyTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.userCompanyTable).pick({
    userId: true,
    companyId: true,
});
exports.keywordTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.keywordTable);
exports.keywordTableUpdateSchema = exports.keywordTableInsertSchema.partial();
exports.keywordTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.keywordTable).pick({
    id: true,
    value: true,
    origin: true,
    companyId: true,
});
exports.userCompanyTenderTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.userCompanyTenderTable);
exports.userCompanyTenderTableUpdateSchema = exports.userCompanyTenderTableInsertSchema.partial();
exports.userCompanyTenderTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.userCompanyTenderTable).pick({
    userId: true,
    companyId: true,
    tenderId: true,
    isBuyAgile: true,
    source: true,
    matchResult: true,
    isFavorite: true,
});
exports.userHistoryTenderTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.userHistoryTenderTable);
exports.userHistoryTenderTableUpdateSchema = exports.userHistoryTenderTableInsertSchema.partial();
exports.userHistoryTenderTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.userHistoryTenderTable).pick({
    userId: true,
    tenderId: true,
});
exports.tenderTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.tenderTable, {
    details: zod_1.z.any(),
});
exports.tenderTableUpdateSchema = exports.tenderTableInsertSchema.partial();
exports.tenderTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.tenderTable).pick({
    id: true,
    code: true,
    name: true,
    description: true,
    subdivisionId: true,
    details: true,
});
exports.userDeviceTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.userDeviceTable);
exports.userDeviceTableUpdateSchema = exports.userDeviceTableInsertSchema.partial();
exports.userDeviceTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.userDeviceTable).pick({
    id: true,
    userId: true,
    token: true,
});
exports.userRequestTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.userRequestTable);
exports.userRequestTableUpdateSchema = exports.userRequestTableInsertSchema.partial();
exports.userRequestTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.userRequestTable).pick({
    id: true,
    userId: true,
    companyId: true,
    tenderId: true,
    stateRequestTypeId: true,
});
exports.userCampaignTableInsertSchema = (0, drizzle_zod_1.createInsertSchema)(exports.userCampaignTable);
exports.userCampaignTableUpdateSchema = exports.userCampaignTableInsertSchema.partial();
exports.userCampaignTableSelectSchema = (0, drizzle_zod_1.createSelectSchema)(exports.userCampaignTable).pick({
    id: true,
    title: true,
    defaultMessage: true,
    dayOfWeek: true,
    defHour: true,
    defMinute: true,
    description: true,
});
//# sourceMappingURL=schema.js.map