"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var DrizzleModule_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DrizzleModule = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const mysql2_1 = require("drizzle-orm/mysql2");
const promise_1 = require("mysql2/promise");
const drizzle_constants_1 = require("./drizzle.constants");
const drizzle_logger_1 = require("./drizzle.logger");
const drizzle_provider_1 = require("./drizzle.provider");
const app_exception_logger_1 = require("../definition/logger/app.exception.logger");
let DrizzleModule = DrizzleModule_1 = class DrizzleModule {
    constructor(dbConfigService, configService) {
        this.dbConfigService = dbConfigService;
        this.configService = configService;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(DrizzleModule_1.name);
    }
    async onModuleInit() {
        const shouldRunMigrations = this.configService
            .get('DB_RUN_MIGRATIONS', 'false')
            .toLowerCase() === 'true';
        const shouldSeed = this.configService.get('DB_SEED', 'false').toLowerCase() ===
            'true';
        if (shouldRunMigrations) {
            this.LOGGER.debug('Running migrations', 'DrizzleModule');
            await this.dbConfigService.migrate();
        }
        if (shouldSeed) {
            this.LOGGER.debug('Running seeds', 'DrizzleModule');
            this.dbConfigService.seed().then((results) => {
                results.forEach((result) => {
                    this.LOGGER.debug(`Seed file ${result.file} executed with ${result.success} success and ${result.error} errors`, 'DrizzleModule');
                });
            });
        }
    }
    onModuleDestroy() {
        this.dbConfigService.pool.end();
    }
};
exports.DrizzleModule = DrizzleModule;
exports.DrizzleModule = DrizzleModule = DrizzleModule_1 = __decorate([
    (0, common_1.Module)({
        providers: [
            {
                provide: drizzle_constants_1.MYSQL_CONNECTION,
                inject: [config_1.ConfigService],
                useFactory: async (configService) => {
                    const log = new app_exception_logger_1.PrimeLogger('DrizzleModule.factory');
                    const host = configService.get('DB_HOST');
                    const port = configService.get('DB_PORT');
                    const database = configService.get('DB_DATABASE');
                    const user = configService.get('DB_USERNAME');
                    const password = configService.get('DB_PASSWORD');
                    const logSql = configService.get('DB_LOG_SQL') === 'true';
                    log.debug(`Connecting to ${host}:${port}/${database}`, 'DrizzleModule');
                    const pool = (0, promise_1.createPool)({
                        host,
                        port,
                        database,
                        user,
                        password,
                    });
                    return {
                        connection: pool,
                        drizzle: (0, mysql2_1.drizzle)(pool, {
                            logger: new drizzle_logger_1.DrizzleLogger(logSql, ':'),
                        }),
                    };
                },
            },
            drizzle_provider_1.DBConfigService,
        ],
        exports: [drizzle_constants_1.MYSQL_CONNECTION, drizzle_provider_1.DBConfigService],
    }),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService,
        config_1.ConfigService])
], DrizzleModule);
//# sourceMappingURL=drizzle.module.js.map