"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var HttpExceptionFilter_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpExceptionFilter = exports.ApiErrorExamples = exports.ApiErrorResponse = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const zod_1 = require("zod");
const __1 = require("../");
const app_exception_logger_1 = require("../logger/app.exception.logger");
class ApiErrorResponse {
}
exports.ApiErrorResponse = ApiErrorResponse;
__decorate([
    (0, swagger_1.ApiProperty)({
        example: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
        enum: common_1.HttpStatus,
        enumName: 'HttpStatus',
    }),
    __metadata("design:type", Number)
], ApiErrorResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Internal server error' }),
    __metadata("design:type", String)
], ApiErrorResponse.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: __1.ExceptionType.INTERNAL,
        enum: __1.ExceptionType,
        enumName: 'ExceptionType',
    }),
    __metadata("design:type", String)
], ApiErrorResponse.prototype, "type", void 0);
class ApiErrorExamples {
}
exports.ApiErrorExamples = ApiErrorExamples;
ApiErrorExamples.RECORD_EXIST = {
    status: common_1.HttpStatus.AMBIGUOUS,
    message: 'Record already exists',
    type: __1.ExceptionType.INTERNAL,
};
ApiErrorExamples.FORBIDEN = {
    status: common_1.HttpStatus.FORBIDDEN,
    message: 'Forbidden',
    type: __1.ExceptionType.INTERNAL,
};
ApiErrorExamples.NOT_FOUND = {
    status: common_1.HttpStatus.NOT_FOUND,
    message: 'Not found',
    type: __1.ExceptionType.INTERNAL,
};
ApiErrorExamples.UNAUTHORIZED = {
    status: common_1.HttpStatus.UNAUTHORIZED,
    message: 'Unauthorized',
    type: __1.ExceptionType.INTERNAL,
};
ApiErrorExamples.BAD_REQUEST = {
    status: common_1.HttpStatus.BAD_REQUEST,
    message: 'Bad request',
    type: __1.ExceptionType.INTERNAL,
};
ApiErrorExamples.CONFLICT = {
    status: common_1.HttpStatus.CONFLICT,
    message: 'Conflict',
    type: __1.ExceptionType.INTERNAL,
};
ApiErrorExamples.INTERNAL = {
    status: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
    message: 'Internal server error',
    type: __1.ExceptionType.INTERNAL,
};
let HttpExceptionFilter = HttpExceptionFilter_1 = class HttpExceptionFilter {
    constructor() {
        this.LOGGER = new app_exception_logger_1.PrimeLogger(HttpExceptionFilter_1.name);
    }
    catch(exception, host) {
        const ctx = host.switchToHttp();
        const response = ctx.getResponse();
        const request = ctx.getRequest();
        let status = 500;
        let message = 'Internal server error';
        let type = __1.ExceptionType.INTERNAL;
        const errorName = this.getExceptionConstructorName(exception);
        let exceptionName = exception instanceof Error ? exception.constructor.name : 'UnknownError';
        let exceptionDetails;
        if (exception instanceof common_1.HttpException) {
            status = exception.getStatus();
            message = this.extractMessage(exception.getResponse()) ?? message;
            type =
                exception instanceof __1.PrimeException
                    ? exception.type
                    : __1.ExceptionType.INTERNAL;
        }
        else if (this.isAxiosError(exception)) {
            exceptionDetails = this.extractAxiosErrorDetails(exception);
            message = exceptionDetails.message;
            status = exceptionDetails.status;
            exceptionName = 'AxiosError';
        }
        else if (errorName === 'ZodError' && this.isZodError(exception)) {
            const zodError = exception;
            status = common_1.HttpStatus.BAD_REQUEST;
            message = `Validation error`;
            exceptionDetails = this.formatZodIssues(zodError.issues);
            exceptionName = 'ZodError';
        }
        const stackArray = this.formatStackTrace(exception);
        this.LOGGER.error(`Error Details: ${JSON.stringify({
            errorName,
            message: message,
            url: request.url,
            method: request.method,
            status: status,
            details: exceptionDetails,
            stack: stackArray,
        }, null, 2)}`, exceptionName);
        response.status(status).json({ status, message, type });
    }
    isZodError(error) {
        return error instanceof zod_1.ZodError;
    }
    formatZodIssues(issues) {
        if (issues.length === 0) {
            return undefined;
        }
        const formattedIssues = issues.reduce((acc, issue) => {
            const path = issue.path.join('.') || 'Root';
            acc[path] = acc[path] || [];
            acc[path].push({
                code: issue.code,
                message: issue.message,
                fatal: issue.fatal,
            });
            return acc;
        }, {});
        return formattedIssues;
    }
    getExceptionConstructorName(exception) {
        if (exception &&
            typeof exception === 'object' &&
            'constructor' in exception &&
            typeof exception.constructor === 'function' &&
            'name' in exception.constructor) {
            return exception.constructor.name;
        }
        return null;
    }
    extractMessage(response) {
        if (typeof response === 'string') {
            return response;
        }
        else if (typeof response === 'object' && response.message) {
            if (Array.isArray(response.message)) {
                return response.message.join(', ');
            }
            else if (typeof response.message === 'string') {
                return response.message;
            }
            else if (typeof response.message === 'object' &&
                response.message.message) {
                return response.message.message;
            }
        }
        return undefined;
    }
    isAxiosError(exception) {
        return exception && exception.isAxiosError;
    }
    extractAxiosErrorDetails(exception) {
        return {
            message: exception.message,
            status: exception.response?.status,
            statusText: exception.response?.statusText,
            headers: exception.response?.headers,
            data: exception.response?.data,
            requestConfig: {
                url: exception.config?.url,
                method: exception.config?.method,
                data: exception.config?.data,
            },
        };
    }
    formatStackTrace(exception) {
        if (typeof exception?.stack === 'string') {
            return exception.stack.split('\n').map((line) => line.trim());
        }
        return [exception];
    }
};
exports.HttpExceptionFilter = HttpExceptionFilter;
exports.HttpExceptionFilter = HttpExceptionFilter = HttpExceptionFilter_1 = __decorate([
    (0, common_1.Catch)()
], HttpExceptionFilter);
//# sourceMappingURL=http-exception.filter.js.map