import { UserRoleService, UserService } from 'src/framework/application';
import { RoleShortNameEnum } from '../../decorators/allow-profiles/allow-roles.decorator';
import { InsertUser, UpdateUser, User, UserPage, UserRoleTO } from 'src/framework/domain';
export declare class UserController {
    private readonly userService;
    private readonly userRoleService;
    private readonly LOGGER;
    constructor(userService: UserService, userRoleService: UserRoleService);
    update(user: User, userData: UpdateUser): Promise<User>;
    save(user: InsertUser): Promise<User>;
    findById(user: User, userId: number): Promise<User | null | undefined>;
    findAll(): Promise<User[]>;
    updateAggrement(user: User): Promise<string>;
    updateProfiles(params: UserRoleTO): Promise<string>;
    findAllPaginated(page: number, pageSize: number, profile?: RoleShortNameEnum): Promise<UserPage[]>;
}
