"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var TypeMasterController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeMasterController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../..");
const api_default_responses_decorator_1 = require("../../decorators/api-default-responses/api-default-responses.decorator");
const allow_roles_decorator_1 = require("../../decorators/allow-profiles/allow-roles.decorator");
let TypeMasterController = TypeMasterController_1 = class TypeMasterController {
    constructor(typeMasterService) {
        this.typeMasterService = typeMasterService;
        this.LOGGER = new framework_1.PrimeLogger(TypeMasterController_1.name);
    }
    async save(user) {
        this.LOGGER.log(`save - user: ${JSON.stringify(user)}`);
        return await this.typeMasterService.createTypeMaster(user);
    }
    async findById(id) {
        this.LOGGER.log(`findById - id: ${id}`);
        return await this.typeMasterService.getTypeMasterById(id);
    }
    async findByDiscriminator(id) {
        this.LOGGER.log(`findByDiscriminator - discriminator: ${id}`);
        return await this.typeMasterService.getTypeMasterByDiscriminator(id);
    }
};
exports.TypeMasterController = TypeMasterController;
__decorate([
    (0, common_1.Post)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: framework_1.TypeMaster }),
    (0, swagger_1.ApiBody)({ type: framework_1.InsertTypeMaster }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.InsertTypeMaster]),
    __metadata("design:returntype", Promise)
], TypeMasterController.prototype, "save", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: framework_1.TypeMaster }),
    (0, swagger_1.ApiParam)({ name: 'id', type: 'number' }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], TypeMasterController.prototype, "findById", null);
__decorate([
    (0, common_1.Get)(':discriminator'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: framework_1.TypeMaster }),
    (0, swagger_1.ApiParam)({ name: 'discriminator', type: 'string' }),
    __param(0, (0, common_1.Param)('discriminator')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], TypeMasterController.prototype, "findByDiscriminator", null);
exports.TypeMasterController = TypeMasterController = TypeMasterController_1 = __decorate([
    (0, swagger_1.ApiTags)('type-master'),
    (0, common_1.Controller)('type-master'),
    __param(0, (0, common_1.Inject)('TypeMasterService')),
    __metadata("design:paramtypes", [Object])
], TypeMasterController);
//# sourceMappingURL=type-master.controller.js.map