"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var NotificationController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../..");
const api_default_responses_decorator_1 = require("../../decorators/api-default-responses/api-default-responses.decorator");
const allow_roles_decorator_1 = require("../../decorators/allow-profiles/allow-roles.decorator");
const prime_user_decorator_1 = require("../../decorators/prime-user/prime-user.decorator");
const user_device_entity_1 = require("../../../domain/entities/user-device.entity");
const test_email_to_1 = require("../../../domain/dto/test-email.to");
const test_notification_to_1 = require("../../../domain/dto/test-notification.to");
const notification_record_entity_1 = require("../../../domain/entities/notification-record.entity");
let NotificationController = NotificationController_1 = class NotificationController {
    constructor(emailService, userDeviceService, firebaseService, notificationRecordService) {
        this.emailService = emailService;
        this.userDeviceService = userDeviceService;
        this.firebaseService = firebaseService;
        this.notificationRecordService = notificationRecordService;
        this.LOGGER = new framework_1.PrimeLogger(NotificationController_1.name);
    }
    async getNotificationRecordsPaginated(user, page, pageSize) {
        this.LOGGER.log(`GetPaginatedNotificationRecords for user ${user.id} page ${page} pageSize ${pageSize}`);
        return await this.notificationRecordService.getNotificationRecordsPaginated(user.id, page, pageSize);
    }
    async sendNotificationAdmin() {
        this.LOGGER.warn(`sendNotificationAdmin`);
        this.firebaseService.notifyToAdminUsers();
    }
    async saveDeviceToken(user, deviceInfo) {
        this.LOGGER.log(`Saving device token for user ${user.id}`);
        await this.userDeviceService.saveUserDevice(user.id, deviceInfo);
        return 'true';
    }
    async testEmail(emailParams) {
        this.LOGGER.log(`Sending email to ${emailParams.email}`);
        await this.emailService.sendAdminEmail(emailParams.email, emailParams.title, emailParams.body);
    }
    async testNotification(params) {
        const data = { type_message: 'general_tender_alert' };
        const devicesList = await this.userDeviceService.findTokensByUserId(params.userId);
        this.LOGGER.log(`Sending notification to user ${params.userId} with devices: ${devicesList.length}`);
        const response = await this.firebaseService.sendPushNotification(devicesList, params.title, params.body, data);
        this.LOGGER.warn(`Notification sent to user ${params.userId} with response: ${JSON.stringify(response)}`);
    }
};
exports.NotificationController = NotificationController;
__decorate([
    (0, common_1.Get)(':page/:pageSize'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [notification_record_entity_1.NotificationRecord] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('page')),
    __param(2, (0, common_1.Param)('pageSize')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, Number]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "getNotificationRecordsPaginated", null);
__decorate([
    (0, common_1.Post)('send-notification-admin'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "sendNotificationAdmin", null);
__decorate([
    (0, common_1.Post)('save-device-token'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiBody)({ type: user_device_entity_1.InsertUserDevice }),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User,
        user_device_entity_1.InsertUserDevice]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "saveDeviceToken", null);
__decorate([
    (0, common_1.Post)('test-email'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiBody)({ type: test_email_to_1.TestEmailTo }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [test_email_to_1.TestEmailTo]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "testEmail", null);
__decorate([
    (0, common_1.Post)('test-notification'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiBody)({ type: test_notification_to_1.TestNotificationTo }),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [test_notification_to_1.TestNotificationTo]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "testNotification", null);
exports.NotificationController = NotificationController = NotificationController_1 = __decorate([
    (0, common_1.Controller)('notification'),
    (0, swagger_1.ApiTags)('notification'),
    __param(0, (0, common_1.Inject)('EmailService')),
    __param(1, (0, common_1.Inject)('UserDeviceService')),
    __param(2, (0, common_1.Inject)('FirebaseService')),
    __param(3, (0, common_1.Inject)('NotificationRecordService')),
    __metadata("design:paramtypes", [Object, Object, Object, Object])
], NotificationController);
//# sourceMappingURL=notification.controller.js.map