"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var GeoController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeoController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../..");
const api_default_responses_decorator_1 = require("../../decorators/api-default-responses/api-default-responses.decorator");
const subdivision_entity_1 = require("../../../domain/entities/subdivision.entity");
let GeoController = GeoController_1 = class GeoController {
    constructor(geoService) {
        this.geoService = geoService;
        this.LOGGER = new framework_1.PrimeLogger(GeoController_1.name);
    }
    async findCountries() {
        this.LOGGER.log('Finding all countries');
        return await this.geoService.findCountries();
    }
    async findCountryById(code) {
        this.LOGGER.log(`Finding country by code: ${code}`);
        return await this.geoService.findCountryById(code);
    }
    async findSubdivisionsByCountryCode(code) {
        this.LOGGER.log(`Finding subdivisions by country code: ${code}`);
        return await this.geoService.findSubdivisionsByCountryCode(code);
    }
    async findAdmdivisionsBySubdivisionCode(code) {
        this.LOGGER.log(`Finding administrative divisions by subdivision code: ${code}`);
        return await this.geoService.findAdmdivisionsBySubdivisionCode(code);
    }
};
exports.GeoController = GeoController;
__decorate([
    (0, common_1.Get)('countries'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: [framework_1.Country] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], GeoController.prototype, "findCountries", null);
__decorate([
    (0, common_1.Get)('countries/:code'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: framework_1.Country }),
    __param(0, (0, common_1.Param)('code')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], GeoController.prototype, "findCountryById", null);
__decorate([
    (0, common_1.Get)('countries/:code/subdivisions'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: [subdivision_entity_1.Subdivision] }),
    __param(0, (0, common_1.Param)('code')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], GeoController.prototype, "findSubdivisionsByCountryCode", null);
__decorate([
    (0, common_1.Get)('/subdivisions/:code/administrative-division'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: [subdivision_entity_1.Subdivision] }),
    __param(0, (0, common_1.Param)('code')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], GeoController.prototype, "findAdmdivisionsBySubdivisionCode", null);
exports.GeoController = GeoController = GeoController_1 = __decorate([
    (0, swagger_1.ApiTags)('geo'),
    (0, common_1.Controller)('geo'),
    __param(0, (0, common_1.Inject)('GeoService')),
    __metadata("design:paramtypes", [Object])
], GeoController);
//# sourceMappingURL=geo.controller.js.map