"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPage = exports.User = exports.UpdateUser = exports.InsertUser = void 0;
const swagger_1 = require("@nestjs/swagger");
class User {
    constructor(id, name, email, lastName, lastName2, cellPhone, externalId, aggrementDate) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.lastName = lastName;
        this.lastname2 = lastName2;
        this.cellPhone = cellPhone;
        this.externalId = externalId;
        this.aggrementDate = aggrementDate;
    }
}
exports.User = User;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'User id',
        example: 1,
    }),
    __metadata("design:type", Number)
], User.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'User name',
        example: 'John Doe',
    }),
    __metadata("design:type", String)
], User.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'User email',
        example: 'john@doe.com',
    }),
    __metadata("design:type", String)
], User.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'User last name',
        example: 'Doe',
        required: false,
        type: String,
    }),
    __metadata("design:type", Object)
], User.prototype, "lastName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'User second last name',
        example: 'Doe',
        required: false,
        type: String,
    }),
    __metadata("design:type", Object)
], User.prototype, "lastname2", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'User cell phone',
        example: '1234567890',
        required: false,
        type: String,
    }),
    __metadata("design:type", Object)
], User.prototype, "cellPhone", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'User external id',
        example: '1234567890',
        required: false,
        type: String,
    }),
    __metadata("design:type", String)
], User.prototype, "externalId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Last update date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
        type: Date,
    }),
    __metadata("design:type", Object)
], User.prototype, "aggrementDate", void 0);
class InsertUser extends (0, swagger_1.OmitType)(User, ['id']) {
}
exports.InsertUser = InsertUser;
class UpdateUser extends (0, swagger_1.PartialType)(InsertUser) {
}
exports.UpdateUser = UpdateUser;
class UserPage extends (0, swagger_1.OmitType)(User, ['lastname2', 'cellPhone', 'externalId', 'aggrementDate']) {
}
exports.UserPage = UserPage;
//# sourceMappingURL=user.entity.js.map