import { Role, UserPage, UserRoleTO } from 'src/framework/domain';
import { RoleShortNameEnum } from 'src/framework/infrastructure/decorators/allow-profiles/allow-roles.decorator';
export interface UserRoleService {
    createUserRole(userId: number, roleId: number): Promise<boolean>;
    getAllPaginated(page: number, pageSize: number, profile?: RoleShortNameEnum): Promise<UserPage[]>;
    getAdminUserIds(): Promise<number[]>;
    getRolesByUserId(userId: number): Promise<string[]>;
    updateProfiles(params: UserRoleTO, profileId: number): Promise<void>;
    getUserRoles(id: number): Promise<Role[]>;
}
