import { InsertNotificationRecord, NotificationRecord, UpdateNotificationRecord } from "src/framework/domain";
import { TxType } from "src/framework/infrastructure";
export interface NotificationRecordService {
    getNotificationRecordsPaginated(userId: number, page: number, pageSize: number): Promise<NotificationRecord[]>;
    getUserNotificationRecordsActive(): Promise<NotificationRecord[]>;
    getAdminNotification(): Promise<NotificationRecord[]>;
    saveAll(notificationRecords: InsertNotificationRecord[], tx?: TxType): Promise<void>;
    updateNotification(notificationRecordId: number, notificationRecord: UpdateNotificationRecord, tx?: TxType): Promise<void>;
    getActiveNotificationRecords(userId: number, isAdmin?: boolean): Promise<NotificationRecord[]>;
    logicalRemoveBYListId(notificationRecordIds: number[], tx?: TxType): Promise<void>;
    markNotificationEmailAsSent(notificationRecordId: number[], tx?: TxType): Promise<void>;
    erraseNotificationRecordsByTender(tenderIds: number[], tx?: TxType): Promise<void>;
}
