import * as admin from 'firebase-admin';
import { BatchResponse } from 'firebase-admin/lib/messaging/messaging-api';
import { UserService } from '../user-service/user-service.interface';
type NotificationData = {
    [key: string]: string;
};
export interface FirebaseService {
    verifyIdToken(idToken: string): Promise<admin.auth.DecodedIdToken>;
    sendPushNotification(tokens: string[], title: string, body: string, data?: NotificationData): Promise<BatchResponse | undefined>;
    deleteUserFromFirebase(uid: string): Promise<void>;
    sendDailyEmailSumary(applicationLogId: number): Promise<string>;
    sendEmailSumaryToAdmin(applicationLogId: number, userService: UserService): Promise<string>;
    groupNotifications(userId: number): Promise<void>;
    notifyToAdminUsers(): Promise<void>;
    sendNewsEmail(email: string, dayOfweekLabel: string, amountWordsTender?: number, amountGeoTenders?: number): Promise<void>;
}
export {};
