import { TxType, InsertUserRequest, UserRequest, UpdateUserRequest, RequestTenderTO } from 'src/framework';
import { TenderTO } from 'src/licitaapp/domain';
export interface UserRequestRepository {
    save(dataInsert: InsertUserRequest, userId: number, tx?: TxType): Promise<UserRequest>;
    existUserRequest(userId: number, tenderId: number, companyId: number): Promise<number>;
    findById(id: number, tx?: TxType): Promise<UserRequest | null>;
    update(userRequestId: number, objectUpdateData: UpdateUserRequest, tx?: TxType): Promise<UserRequest | null>;
    getPagination(page: number, pageSize: number, shortStateUserRequest: string, filter: string): Promise<RequestTenderTO[]>;
    logicalRemove(userRequestId: number, tx?: TxType): Promise<void>;
    updateState(userRequestId: number, stateRequestTypeId: number, active: boolean, tx?: TxType): Promise<UserRequest | null>;
    erraseUserRequests(tenderIds: TenderTO[]): Promise<void>;
}
