"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const framework_1 = require("./framework");
const keyword_module_1 = require("./licitaapp/infrastructure/module/keyword/keyword.module");
const user_device_module_1 = require("./framework/infrastructure/module/user-device/user-device.module");
const history_tender_module_1 = require("./licitaapp/infrastructure/module/history-tender/history-tender.module");
const licitaapp_1 = require("./licitaapp");
const application_log_module_1 = require("./licitaapp/infrastructure/module/application-log/application-log.module");
const notification_record_module_1 = require("./framework/infrastructure/module/notification-record/notification-record.module");
const schedule_mp_module_1 = require("./licitaapp/infrastructure/module/schedule-mp/schedule-mp.module");
const schedule_1 = require("@nestjs/schedule");
const core_1 = require("@nestjs/core");
const user_campaigns_module_1 = require("./framework/infrastructure/module/user-campaigns/user-campaigns.module");
const fwk_cache_module_1 = require("./framework/infrastructure/module/fwk-cache/fwk-cache.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot({
                isGlobal: true,
                envFilePath: '.env.dev',
            }),
            schedule_1.ScheduleModule.forRoot(),
            fwk_cache_module_1.FwkCacheModule,
            framework_1.DrizzleModule,
            framework_1.NotificationModule,
            user_device_module_1.UserDeviceModule,
            framework_1.RoleModule,
            framework_1.UserRoleModule,
            keyword_module_1.KeywordModule,
            framework_1.UserModule,
            framework_1.TypeMasterModule,
            framework_1.GeoModule,
            framework_1.UserRequestModule,
            history_tender_module_1.HistoryTenderModule,
            licitaapp_1.CompanyModule,
            licitaapp_1.TenderModule,
            application_log_module_1.ApplicationLogModule,
            notification_record_module_1.NotificationRecordModule,
            schedule_mp_module_1.ScheduleMpModule,
            user_campaigns_module_1.UserCampaignsModule,
            licitaapp_1.MercadoPublicoModule
        ],
        providers: [
            {
                provide: core_1.APP_GUARD,
                useClass: framework_1.PrimeFirebaseAuthGuard,
            },
        ],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map